# Kvaser CAN Extcap

An [Extcap](https://www.wireshark.org/docs/wsdg_html_chunked/ChCaptureExtcap.html) for Wireshark made to capture CAN and CANFD packets in the PcapNG format on devices from Kvaser AB using it's CANlib.

## Prerequisites

To use the external capture program the Kvaser drivers need to be installed, these can be found [here](https://kvaser.com/download/) for both Linux and Windows.

## Usage

To install the extcap, so that it can be used with Wireshark, look at the [Install](#install) section, a simple user guide can be found in GETSTARTED.

### Standalone

The executable can also be used by itself. This just means that the capture is made to a specified file (in the PcapNG format) that can then be read by Wireshark or used in any other way. More information can be found [here](https://www.wireshark.org/docs/man-pages/extcap.html).

Configuration is done by passing arguments to the executable and these can be found by using the `-h` flag.

A CAN example with logging: .\kvaser_can_extcap.exe --capture --extcap-interface 0 --fifo C:\Users\\$USER$\extcap\test.pcapng  --pcapng_interface_info --bitrate -2 --log --log_level 4 --logfile C:\Users\\$USER$\extcap\logs\test.log

## Compile

### Dependencies

To build the extcap [CANlib SDK](https://kvaser.com/download/) (installed on default path), [Meson](https://mesonbuild.com/Getting-meson.html) and [ninja](https://ninja-build.org/) needs to be installed. There might be additional dependecies based on which operating system is used, in that case they will be found below under either the Windows or Linux headers.

### Windows

Both MSVC and MSYS2 can be used to compile the extcap (for now, this might change).

For Windows the Microsoft [build tools](https://visualstudio.microsoft.com/downloads/?q=build+tools) are needed for the MSVC compiler, this is the recommened compiler to use. Besides the build tools, MINGW64 from the [MSYS2](https://www.msys2.org/) tool collection can be used to compile. For this only the gcc compiler has been tested.

To compile the extcap the script build.ps1 can be used for MSVC. The usage of the script can be printed with the `-help` or `-h` flags. It is **IMPORTANT** that the script is run from the folder where it is located. The script have 4 different compile versions:

    - Debug
    - Release
    - Debug with optimizations
    - Minimal size

The script will create an executable called kvaser_can_extcap.exe under the created *build* directory. The easiest way to build the project is to use the `Developer Powershell for Visual Studio` for Visual Studio 2022 version 17.1 or later. To get the Developer Powershell run the command below in Powershell and make sure the correct version of Visual Studio is used (Community or Professional) as well as the architectures, or check the [Microsoft Documentation](https://learn.microsoft.com/en-us/visualstudio/ide/reference/command-prompt-powershell?view=vs-2022). At the moment only the amd64 architecture is supported for the target system and host.

    & 'C:\Program Files\Microsoft Visual Studio\2022\Community\Common7\Tools\Launch-VsDevShell.ps1' -Arch amd64 -HostArch amd64

Then the below command can be used to build the executable.

    .\build.ps1 -build release

A script, build-mingw.sh, also exist to compile for Windows with the MSYS2 tool collection. To do this the MSYS2 tool collection needs to be installed (along side the above dependecies) so that the `MINGW64` application can be used. Once that is done locate the project folder and execute the script as shown below.

    .\build-mingw.sh release

This will place the executable in the *build* directory, which can then be used as normal.

### Linux

To compile on Linux gcc has been used, clang might work but is has not been tested.

To compile the extcap the script build.sh can be used. The usage of the script can be printed with the `-h` flag. The script have 4 different compile versions:

    - Debug
    - Release
    - Debug with optimizations
    - Minimal size

The script will create an executable called kvaser_can_extcap under the created *build* directory. A *Release* version can be built using the command shown below.

    ./build.sh -b release

## Installation

Prebuilt versions of the extcap for Windows and Linux can be found on the [Kvaser download page](https://kvaser.com/download/). These executable files need to be placed in the *exctap* folder in the Wireshark directory, check the corresponding subheader below to find were that folder might be.

### Windows

If an executable has been built using the steps in the [Compile section](#compile "Compile") then the command below can be used to install the extcap. The command will search for the extcap folder in the Wireshark directory. *Administrator* permissions are required to install the executable with the script.

    .\build.ps1 -install

If the command fails to install the extcap it can be installed manually by placing the executable in the `extcap` folder in the Wireshark directory. On Windows this is usually located at `C:\Program Files\Wireshark\extcap` if the default path was used during intallation.

### Linux

If an executable has been built using the steps in the [Compile section](#compile "Compile") then the command below can be used to install the extcap. The command will search for the Wireshark directory and place the executable in the extcap folder. To install the executable the script requires *sudo* permissons.

    .\build.sh -i

If the command fails to install the extcap it can be installed manually by placing the executable in the `extcap` folder in the Wireshark directory. On Linux (Ubuntu) this is usually located at `/usr/lib/x86_64-linux-gnu/wireshark/extcap`.

## Known issues

- No support for capturing from multiple interfaces at the same time. Wireshark supports it but the extcap does not.
- No support for non-ISO canFD.
- CTRL-C is not handled so shutdown is not handled gracefully.
- The time written to the logfile does not correspond the the format used in Wireshark.

## License

Kvaser CAN Extcap is distributed under the GNU GPLv2 license. Look at the LICENSE file to see the full license text.

If you have received a version of this software in binary form that gives you the right to receive the source code for this binary, to obtain a copy of the source code contact Kvaser AB support. This can be done via mail (<support@kvaser.com>) or via the webpage (<https://kvaser.com/support/>).

Your request should include:

- The name of the binary file for which you are requesting the source code (in this case: Kvaser CAN Extcap)
- The version number of the binary
- The date you received the product
- Your name
- Your company name (if applicable)
- The return email to which the source code should be sent

To retrive the version of the binary use the command ```--extcap-interfaces```, the version will be printed at the top.
