# Client API Samples

This repo contains some sample code to showcase how to initialize and run a few
API calls. It currently conists of simple_c, and simple_cpp, each doing 
essentially the same thing but each in an idiomatic way.

## Prerequisites

### Linux

To build on Linux you'll need:
- cmake
- gcc
- g++

Which on debian based distros can be installed with:
```
sudo apt-get update && sudo apt-get install build-essential cmake
```

### Windows

On Windows you'll need:
- VisualStudio 2022 (BuildTools will work, no need for the full 
IDE)
- cmake (can be installed as a component when installing Visual Studio)

## To build the samples

0. Since you're reading this README, one might expect you already extracted the released archive (*.zip on Windows, *.tar.gz on Linux). If not, do so now.

1. Inside the extracted archive you'll want to navigate to \<extracted_release\>/samples.

2. Start a terminal/command prompt

3. Run `cmake -B build .`

4. Run `cmake --build build`

5. Run the built applications with:

```
# Linux:
./build/simple_c_static
./build/simple_cpp_static
./build/simple_c_shared
./build/simple_cpp_shared

# Windows
./build/Debug/simple_c_static.exe
./build/Debug/simple_cpp_static.exe
./build/Debug/simple_c_shared.exe
./build/Debug/simple_cpp_shared.exe
```
