package com.kvaser.canlib;

import android.os.*;
/**
 * Interface for a Kvaser device driver.
 */
interface KvDeviceInterface extends UsbListener {

  public void close();
  public int getNumberOfChannels();
  public boolean isVirtual();
  public void setBusParams(int channelIndex, CanBusParams busParams) throws CanLibException;
  public CanBusParams getBusParams(int channelIndex) throws CanLibException;
  public void busOn(int channelIndex) throws CanLibException;
  public void busOff(int channelIndex) throws CanLibException;
  public void setBusOutputControl(int channelIndex, CanDriverType driverType) throws CanLibException;
  public CanDriverType getBusOutputControl(int channelIndex) throws CanLibException;
  public void write(int channelIndex, CanMessage msg) throws CanLibException;
  public Bundle getDeviceInfo();
  public Ean getEan();
  public int getSerialNumber();
  public void flashLeds();
  public void registerCanChannelEventListener(CanChannelEventListener listener);
  public void unregisterCanChannelEventListener(CanChannelEventListener listener);
}